/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFType_Int;
import fme.CFType_MesAno;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.Frame_DadosAccoes;
import fme.GroupableTableHeaderUI;
import fme.TabError;
import fme.TableKeyListener;

class CBTabela_Calend
extends CBTabela {
    Frame_DadosAccoes P;
    int tab_index = 0;

    @Override
    public String getPagina() {
        return CBData.getPagina(null, "Accoes", CBData.ListaAccoes, this.tab_index);
    }

    CBTabela_Calend(Frame_DadosAccoes p, int idx) {
        this.P = p;
        this.tab_index = idx;
        this.initialize();
    }

    void initialize() {
        this.tag = "Calendario";
        this.started = true;
        this.P.cbd_calend = this;
        this.cols = new CHTabColModel[9];
        this.cols[0] = new CHTabColModel("n_ordem", "N\u00ba", true, false, true, new CFType_Int());
        this.cols[1] = new CHTabColModel("descricao", "Descri\u00e7\u00e3o", true, true, true, null);
        this.cols[2] = new CHTabColModel("local", "Localiza\u00e7\u00e3o", true, true, true, null);
        this.cols[3] = new CHTabColModel("inicio_f1", "In\u00edcio<br>(mm-aaaa)", true, CBData.Params.fases > 0, true, new CFType_MesAno());
        this.cols[4] = new CHTabColModel("fim_f1", "Fim<br>(mm-aaaa)", true, CBData.Params.fases > 0, true, new CFType_MesAno());
        this.cols[5] = new CHTabColModel("inicio_f2", "In\u00edcio<br>(mm-aaaa)", true, CBData.Params.fases > 1, true, new CFType_MesAno());
        this.cols[6] = new CHTabColModel("fim_f2", "Fim<br>(mm-aaaa)", true, CBData.Params.fases > 1, true, new CFType_MesAno());
        this.cols[7] = new CHTabColModel("inicio_f3", "In\u00edcio<br>(mm-aaaa)", true, CBData.Params.fases > 2, true, new CFType_MesAno());
        this.cols[8] = new CHTabColModel("fim_f3", "Fim<br>(mm-aaaa)", true, CBData.Params.fases > 2, true, new CFType_MesAno());
        this.init_dados(8);
        this.init_handler(this.P.getJTable_Calend());
        this.P.getJTable_Calend().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.P.getJScrollPane_Calend().getWidth() - 2;
        this.handler.set_col_text(0, 0.045, "C");
        this.handler.set_col_text(1, 0.276, null);
        this.handler.set_col_text(2, 0.169, null);
        this.handler.set_col_text(3, 0.083, "C");
        this.handler.set_col_text(4, 0.083, "C");
        this.handler.set_col_text(5, 0.083, "C");
        this.handler.set_col_text(6, 0.083, "C");
        this.handler.set_col_text(7, 0.083, "C");
        this.handler.set_col_text(8, 0.083, "C");
        this.ui = new GroupableTableHeaderUI();
        this.ui.setH(3, this.P.getJTable_Calend());
        this.ui.add_col(0, 0, 1, 3, "N\u00ba");
        this.ui.add_col(1, 0, 1, 3, "Descri\u00e7\u00e3o");
        this.ui.add_col(2, 0, 1, 3, "Localiza\u00e7\u00e3o");
        this.ui.add_col(3, 0, 2, 1, "Fase 1");
        this.ui.add_col(3, 1, 1, 2, "<html><center>In\u00edcio<br>(mm-aaaa)</center></html>");
        this.ui.add_col(4, 1, 1, 2, "<html><center>Fim<br>(mm-aaaa)</center></html>");
        this.ui.add_col(5, 0, 2, 1, "Fase 2");
        this.ui.add_col(5, 1, 1, 2, "<html><center>In\u00edcio<br>(mm-aaaa)</center></html>");
        this.ui.add_col(6, 1, 1, 2, "<html><center>Fim<br>(mm-aaaa)</center></html>");
        this.ui.add_col(7, 0, 2, 1, "Fase 3");
        this.ui.add_col(7, 1, 1, 2, "<html><center>In\u00edcio<br>(mm-aaaa)</center></html>");
        this.ui.add_col(8, 1, 1, 2, "<html><center>Fim<br>(mm-aaaa)</center></html>");
        this.P.getJTable_Calend().getTableHeader().setUI(this.ui);
    }

    @Override
    void on_update(String colname, int nRow, String v) {
        this.numerar(0);
    }

    CHValid_Grp validar(CHValid_Grp err_list, String cp) {
        String titulo = "Calend\u00e1rio";
        if (cp.length() > 0) {
            titulo = String.valueOf(titulo) + cp;
        }
        if (err_list == null) {
            err_list = new CHValid_Grp(this, titulo);
        }
        if (this.isEmpty()) {
            err_list.add_msg(new CHValid_Msg("Lista vazia"));
        } else {
            String all_fim_f1 = "";
            String all_ini_f2 = "";
            String all_fim_f2 = "";
            String all_ini_f3 = "";
            int j = 0;
            while (j < this.dados.size()) {
                if (!this.isRowEmpty(j)) {
                    String mask = "-RR------";
                    TabError[] e = this.isIncompletAll(j, mask.toString());
                    int ii = 0;
                    while (e != null && ii < e.length) {
                        err_list.add_msg(new CHValid_Msg(e[ii]));
                        ++ii;
                    }
                    String ini_f1 = this.convert_mes_ano(this.getColValue("inicio_f1", j));
                    String fim_f1 = this.convert_mes_ano(this.getColValue("fim_f1", j));
                    String ini_f2 = this.convert_mes_ano(this.getColValue("inicio_f2", j));
                    String fim_f2 = this.convert_mes_ano(this.getColValue("fim_f2", j));
                    String ini_f3 = this.convert_mes_ano(this.getColValue("inicio_f3", j));
                    String fim_f3 = this.convert_mes_ano(this.getColValue("fim_f3", j));
                    if (fim_f1.length() > 0 && fim_f1.compareTo(all_fim_f1) > 0) {
                        all_fim_f1 = fim_f1;
                    }
                    if (ini_f2.length() > 0 && (ini_f2.compareTo(all_ini_f2) < 0 || all_ini_f2.length() == 0)) {
                        all_ini_f2 = ini_f2;
                    }
                    if (fim_f2.length() > 0 && fim_f2.compareTo(all_fim_f2) > 0) {
                        all_fim_f2 = fim_f2;
                    }
                    if (ini_f3.length() > 0 && (ini_f3.compareTo(all_ini_f3) < 0 || all_ini_f3.length() == 0)) {
                        all_ini_f3 = ini_f3;
                    }
                    String linha = "Linha " + String.valueOf(j + 1);
                    String linha_inc = String.valueOf(linha) + " incompleta: ";
                    if (ini_f1.equals("") && fim_f1.equals("") && ini_f2.equals("") && fim_f2.equals("") && ini_f3.equals("") && fim_f3.equals("")) {
                        err_list.add_msg(new CHValid_Msg(String.valueOf(linha_inc) + "Pelo menos uma das fases tem que ter calendariza\u00e7\u00e3o", j, this.getColIndex("descricao")));
                    } else {
                        int fase = 0;
                        int col = 3;
                        while (col <= 8) {
                            ++fase;
                            String tag = this.cols[col].col_tag;
                            String data_i = this.convert_mes_ano(this.getColValue(tag, j));
                            if (tag.startsWith("inicio_")) {
                                String data_f = this.convert_mes_ano(this.getColValue(this.cols[col + 1].col_tag, j));
                                if (data_i.equals("") && !data_f.equals("")) {
                                    err_list.add_msg(new CHValid_Msg(String.valueOf(linha_inc) + "Fase " + fase + " - tem que indicar a data de in\u00edcio", j, col));
                                } else if (!data_i.equals("") && data_f.equals("")) {
                                    err_list.add_msg(new CHValid_Msg(String.valueOf(linha_inc) + "Fase " + fase + " - tem que indicar a data de fim", j, col + 1));
                                } else if (!data_i.equals("") && !data_f.equals("") && data_i.compareTo(data_f) > 0) {
                                    err_list.add_msg(new CHValid_Msg(String.valueOf(linha) + ": Fase " + fase + " - a data de fim tem de ser posterior \u00e0 data de in\u00edcio", j, col + 1));
                                }
                            }
                            ++col;
                            ++col;
                        }
                    }
                }
                ++j;
            }
            if (all_fim_f1.length() > 0 && all_ini_f2.length() > 0 && all_fim_f1.compareTo(all_ini_f2) > 0) {
                err_list.add_msg(new CHValid_Msg("O In\u00edcio da Fase 2 (" + this.undo_convert_mes_ano(all_ini_f2) + ") tem de ser posterior ao Fim da Fase 1 (" + this.undo_convert_mes_ano(all_fim_f1) + ")"));
            }
            if (all_fim_f2.length() > 0 && all_ini_f3.length() > 0 && all_fim_f2.compareTo(all_ini_f3) > 0) {
                err_list.add_msg(new CHValid_Msg("O In\u00edcio da Fase 3 (" + this.undo_convert_mes_ano(all_ini_f3) + ") tem de ser posterior ao Fim da Fase 2 (" + this.undo_convert_mes_ano(all_fim_f2) + ")"));
            }
        }
        return err_list;
    }

    String convert_mes_ano(String mes_ano) {
        if (mes_ano.length() > 0) {
            mes_ano = String.valueOf(mes_ano.substring(3)) + "-" + mes_ano.substring(0, 2);
        }
        return mes_ano;
    }

    String undo_convert_mes_ano(String ano_mes) {
        if (ano_mes.length() > 0) {
            ano_mes = String.valueOf(ano_mes.substring(5)) + "-" + ano_mes.substring(0, 4);
        }
        return ano_mes;
    }
}

